#version 330
#extension GL_EXT_gpu_shader4 : enable
// colourmap playMod01.fsh  by foxiepaws
//https://www.shadertoy.com/view/tldGRN
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define M_PI 3.14159265358979323846
vec3 colormap(float v,float t) {
    if (t > 160.0) {
        t = mod(t,160.0);
    }
    if (t < 15.0) {
        t = 15.0;
    }
    float tt = (t * 10.0);
    float r = ( .5 + .5 * sin(M_PI * v + tt/(v+3.0)));
    float g = ( .5 + .5 * sin(M_PI * v + M_PI*2.0/(3.0+v)));
    float b = ( .5 + .5 * sin(M_PI * v + M_PI*4.0/(3.0+v)));
    return vec3(r,g,b);
}


float calc (float x, float y, float t) {
    float v = 0.0;
    
    float ar = iResolution.x / iResolution.y;
    float xx = ar* x / (iResolution.x)-ar/2.0;
	float yy = y / iResolution.y - .5;
    float tt = t / 1.0;
    
    
    float cx = xx + 0.5 * sin(tt / 5.0);
    float cy = yy + 0.5 * cos(tt / 3.0);
    
    float v0 = sin((xx * 10.0) + tt);
    float v1 = sin(10.0 * ( xx * sin(tt / 2.0) + yy * cos(tt / 3.0)));
    float v2 = sin(sqrt(100.0*((cx*cx)+(cy*cy)))+1.0+tt);
    
    v = ((v0 + v1 + v2) + cos(v2 + yy + tt)) / 2.0;
    
    
    return v;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float v = calc(gl_FragCoord.x,gl_FragCoord.y,iTime);
    
	gl_FragColor = vec4(colormap(v,iTime),1.0);
}